#ifndef MAINWINDOWIMPL_H
#define MAINWINDOWIMPL_H
//
#include <QMainWindow>
#include <QCloseEvent>
#include <QMenu>
#include <QAction>
#include <QList>
#include "ui_mainwindow.h"
#include "berechnungen.h"
#include "qexport.h"
#include "korrektswimpl.h"
#include "eingabehvolumenimpl.h"
#include "erweitertezutatimpl.h"
#include "rastwidget.h"
#include "doubleeditlineimpl.h"
#include "bewertung.h"

//
class MainWindowImpl : public QMainWindow, public Ui::MainWindow
{
Q_OBJECT
protected:
	void closeEvent(QCloseEvent *event);
	void resizeEvent(QResizeEvent * event);
	void showEvent ( QShowEvent * event ); 
private:
	int MaxAnzahlSterne;
	void LeseMaxAnzahlSterne();
	int NeuBerechnen;
	//Stammwürzenanteil die durch die Erweiterten Zutaten erreicht wird
	double sw_ewz;
	//Stammwürze beim Kochen
	double sw_kochen;
	//Stammwürze Schüttung
	double sw_schuettung;
	//Stammwürze gesammt
	double sw_gesammt;
	void BerWeitereZutaten();
	void SchreibeErweiterteZutatenDB();
	QIcon appIcon;
	void ErstelleErweiterteZutatenliste();
	QList<ErweiterteZutatImpl *> list_EwZutat;
	//Ermittelt den Bewertungsindex in der Liste
	int getBewertungsIndex();
	//Diese Liste enhält alle Bewertungen
	QList<Bewertung *> list_Bewertung;
	QStringList ZutatenTypListe;
	QStringList EinheitenListe;
	QList<Rastwidget *> list_Rasten;
	//Liste Auswählbare Erweiterte Zutaten
	QStringList ewzListe;
	QStringList ewzHopfenListe;
	void ErstelleSudInfo();
	bool AenderungAusruestung;
	bool AenderungGeraeteliste;
	bool AenderungHauptgaerverlauf;
	bool AenderungHopfengaben;
	bool AenderungMalzschuettung;
	void BerRestalkalitaet();
	void BerWasserwerte();
	void CheckPfannevoll();
	void CheckGesammtMaischeMenge();
	void BerPfanneVoll();
	void BerVolumenMaischen();
	void BerEmpfehlungFaktorHauptguss();
	void BerAusruestung();
	void DBErgebnisseNeuBerechnen();
	bool CheckDBNeuBerechnen();
	void SetDisabledVerbraucht(bool status);
	void ErstelleZusammenfassung();
	QColor ColorBrauUebersicht_Spalte1;
	QColor ColorBrauUebersicht_Spalte2;
	QColor ColorBierReift;
	QColor ColorBierFertig;
	QColor ColorBierLeer;
	bool NeueMessungWirdAngelegt;
	void SetDiagrammFarben();
	void SetAnsicht();
	void SetMaxAnzahlSterne();
	void FuelleDiagrammNachgaerverlauf();
	void LeseNachgaerverlaufDB();
	void SchreibeNachgaerverlaufDB();
	void FuelleDiagrammHauptgaerverlauf();
	void LeseHauptgaerverlaufDB();
	void SchreibeHauptgaerverlaufDB();
	void FuelleDiagrammSchnellgaerverlauf();
	void LeseSchnellgaerverlaufDB();
	void SchreibeSchnellgaerverlaufDB();
	void FuelleGaerverlauf();
	void BerEffektiveAusbeuteMittel();
	void FuelleBrauuebersicht();
	void BerKosten();
	void ImportSudDatei(QString Name);
	void SchreibeMalzschuettungDB();
	void SchreibeHopfengabenDB();
	void SchreibeRastenDB();
	void SchreibeSuddatenDB();
	void SchreibeBewertungenDB();
	void SetMalzauswahl(int Nummer, QString Name, double Prozent, int ID, double erg_Menge, double Farbe);
	void FuelleSudauswahl();
	void LeseSuddatenDB();
	void LadeSudDB();
	void LeseRohstoffeDB();
	void LeseRohstoffeDB_test();
	void SchreibeRohstoffeDB();
	void LeseGeraetelisteDB();
	void SchreibeGeraetelisteDB();
	void DatenEinlesenDB();
	void LeseAusruestungDB();
	void BerFarbe(double cEBC = 0);
	void LadeBild();
	bool ComboboxWirdGefuellt;
	bool AenderungRohstofftabelle;
	QString GetWertString(double value);
	void CheckHopfenProzent();
	void SetStatusHopfengaben();
	void SetHopfen(int nummer, bool Aktiv, QString Name, int Zeit, int Menge, int ID, double erg_Menge, QString erg_Text, double Alpha, int Pellets);
	bool AbfrageSpeichern();
	bool Aenderung;
	QString strippedName(const QString &fullFileName);
	int strippedID(const QString &fullFileName);
	void updateRecentFileActions();
	void CheckJungbierSW();
	void CheckRohstoffeVorhanden();
	void CheckMalzProzent();
	void CheckFehler();
	void SetDisabledAbgefuellt(bool status);
	void RohstoffeAbziehen();
	QString Pfad;
	void SetDisabledGebraut(bool status);
	void BerBraudaten();
	bool BierWurdeGebraut;
	bool BierWurdeAbgefuellt;
	bool BierWurdeVerbraucht;
	void LeseGeraeteliste();
	void ErstelleSpickzettel();
	void BerHopfen();
	void BerWasser();
	void BerSchuettung();
	void BerAlles();
	void FuelleRezeptComboAuswahlen();
	void createMenus();
	void createActions();
	void LeseKonfig();
	void SchreibeKonfig();
	void LeseRohstoffe();
	void DatenSchreibenDB();
	void SchreibeAusruestungDB();
	void LeseAusruestung();
	void setRecentFile(int ID);
	QMenu *fileMenu;
	QMenu *extrasMenu;
	QMenu *recentFilesMenu;
	QAction *saveAct;
	QAction *printAct;
	QAction *makePdf;
	QAction *separatorAct;
	QAction *einstellungen;
	QAction *schuettungProzent;
	QAction *berIBU;
	QAction *EntsperreEingabefelder;
	enum { MaxRecentFiles = 5 };
	QAction *recentFileActs[MaxRecentFiles];
	//QString AktuelleSuddatei;
	int AktuelleSudID;
	QBerechnungen Berechnungen;
	QExport Export;
	bool Gestartet;
	bool AmLaden;
	
	enum RendererType { Native, OpenGL, Image };
	//Die Scene
	QGraphicsScene *scene;
	//Das Bierglasbild
	QGraphicsItem *m_svgItem;
	//Das Rechteck im Hintergrund mit der Entsprechenden Bierfarbe
	QGraphicsItem *rect;
	QGraphicsRectItem *m_backgroundItem;
	QGraphicsRectItem *m_outlineItem;
	//Setzt den Farbeinstellungswert in den Bewertungen
	void setBewertungFarbe();
	//Setzt die Schaumeinstellung in den Bewertungen
	void setBewertungSchaum();
	//Setzt die Gerucheinstellungen in den Bewertungen
	void setBewertungGeruch();
	//Setzt die Geschmackseinstellungen in den Bewertungen
	void setBewertungGeschmack();
	//Setzt die Antrunkseinstellungen in den Bewertungen
	void setBewertungAntrunk();
	//Setzt die Haupttrunkeinstellungen in den Bewertungen
	void setBewertungHaupttrunk();
	//Setzt die Nachtrunkeinstellungen in den Bewertungen
	void setBewertungNachtrunk();
	//Setzt die Gesamteindrucksbewertung in den Bewertungen
	void setBewertungGesamteindruck();
	struct Rohstoff{
		int ID;
		QString Name;
		double Menge;
		double MengeIst;
	};

public:
	MainWindowImpl( QWidget * parent = 0, Qt::WFlags f = 0 );
	bool NativStyle;
private slots:
	void slot_checkBoxHopfenChanged(int value);
	void slot_pushButton_gebraut();
	double slot_getEwzFarbe(QString zutat);
	double slot_getEwzPreis(QString zutat);
	double slot_getEwzPreisHopfen(QString zutat);
	int slot_getEwzAusbeute(QString zutat);
	void slot_EwzAenderung();
	int slot_getEwzEinheit(QString zutat);
	int slot_getEwzTyp(QString zutat);
	void slot_ewzClose(int id);
	void slot_rastClose(int id);
	void slot_bewClose(int id);
	void slot_rastAenderung(int id);
	void on_pushButton_EWZ_Hinzufuegen_clicked();
	void on_tableWidget_WeitereZutaten_itemSelectionChanged();
	void on_pushButton_WeitereZutatenDel_clicked();
	void on_pushButton_WeitereZutatenKopie_clicked();
	void on_pushButton_WeitereZutatenNeu_clicked();
	void on_TabWidget_Zutaten_currentChanged(int index);
	void on_tableWidget_Sudauswahl_itemSelectionChanged();
	void on_tableWidget_Brauuebersicht_cellDoubleClicked(int row, int column);
	void on_tableWidget_Sudauswahl_cellDoubleClicked(int row, int column);
	void slot_AenderungAusruestung(double d);
	void slot_AenderungAusruestung(int d);
	void slot_AenderungGeraeteliste(int row, int column);
	void slot_AenderungHopfengaben(int d);
	void slot_AenderungHopfengabenCombo(int d);
	void slot_AenderungMalzschuettung(double d);
	void slot_AenderungMalzschuettungCombo(int d);
	void on_spinBox_ZeitGabe_1_editingFinished();
	void on_spinBox_ZeitGabe_2_editingFinished();
	void on_spinBox_ZeitGabe_3_editingFinished();
	void on_spinBox_ZeitGabe_4_editingFinished();
	void on_spinBox_ZeitGabe_5_editingFinished();
	void on_spinBox_ZeitGabe_6_editingFinished();
	void on_spinBox_SWVorHopfenseihen_valueChanged(double );
	void on_SpinBox_wwSaeurekapazitaet_mmol_valueChanged(double );
	void on_SpinBox_wwCarbonathaerte_dh_valueChanged(double );
	void on_SpinBox_wwMagnesium_mg_valueChanged(double );
	void on_SpinBox_wwMagnesium_mmol_valueChanged(double );
	void on_SpinBox_wwCalcium_mmol_valueChanged(double );
	void on_SpinBox_wwCalcium_mg_valueChanged(double );
	void on_tableWidget_Brauuebersicht_itemSelectionChanged();
	void on_pushButton_SudImport_clicked();
	void on_pushButton_SudExport_clicked();
	void slot_EntsperreEingabefelder();
	void on_pushButton_EingabeHMengeNHopfenseihen_clicked();
	void on_pushButton_EingabeHMengeVHopfenseihen_clicked();
	void on_pushButton_EingabeHSWVorHopfenseihen_clicked();
	void slot_berIBU();
	void slot_schuettungProzent();
	void on_lineEdit_Sudname_textEdited(QString );
	void on_lineEdit_Sudname_editingFinished();
	void on_pushButton_SudLadenBUebersicht_clicked();
	void on_pushButton_SudVerbraucht_clicked();
	void on_tableWidget_Hauptgaerverlauf_itemChanged(QTableWidgetItem* item);
	void on_tableWidget_Nachgaerverlauf_itemChanged(QTableWidgetItem* item);
	void on_tableWidget_Schnellgaerverlauf_itemChanged(QTableWidgetItem* item);
	void slot_einstellungen();
	void on_pushButton_DelNachgaerMessung_clicked();
	void on_pushButton_AddNachgaerMessung_clicked();
	void on_pushButton_DelHauptgaerMessung_clicked();
	void on_pushButton_EingabeSWHauptgaerverlauf_clicked();
	void on_pushButton_AddHauptgaerMessung_clicked();
	void on_pushButton_DelSchnellgaerMessung_clicked();
	void on_pushButton_EingabeSWSchnellgaerverlauf_clicked();
	void on_pushButton_AddSchnellgaerMessung_clicked();
	void on_pushButton_BrauuebersichtRefresh_clicked();
	void on_comboBox_AuswahlL1_currentIndexChanged(int index);
	void on_comboBox_AuswahlL2_currentIndexChanged(int index);
	void on_tabWidged_selected(QString str);
	void on_spinBox_KostenWasserStrom_valueChanged(double );
	void on_spinBox_KostenWasserStrom_editingFinished();
	void on_pushButton_SpickzettelPDF_clicked();
	void on_pushButton_SpickzettelDrucken_clicked();
	void slot_pushButton_SudKopie();
	void slot_FilterClicked(bool checked);
	void slot_pushButton_SudLaden();
	void slot_pushButton_SudDel();
	int slot_pushButton_SudNeu();
	void slot_lineEdit_editingFinished();
	void slot_pushButton_HopfenProzent_1();
	void slot_pushButton_HopfenProzent_2();
	void slot_pushButton_HopfenProzent_3();
	void slot_pushButton_HopfenProzent_4();
	void slot_pushButton_HopfenProzent_5();
	void slot_pushButton_HopfenProzent_6();
	void slot_pushButton_HopfenProzent_vh();
	void slot_pushButton_MalzProzent_1();
	void slot_pushButton_MalzProzent_2();
	void slot_pushButton_MalzProzent_3();
	void slot_pushButton_MalzProzent_4();
	void slot_pushButton_MalzProzent_5();
	void slot_pushButton_MalzProzent_6();
	void slot_makePdf();
	void slot_pushButton_HefeKopie();
	void slot_pushButton_HopfenKopie();
	void slot_pushButton_MalzKopie();
	void slot_tabWidgetChanged(int);
	void slot_spinBoxspinBox_ZeitGabe_1Changed(int value);
	void slot_spinBoxspinBox_ZeitGabe_2Changed(int value);
	void slot_spinBoxspinBox_ZeitGabe_3Changed(int value);
	void slot_spinBoxspinBox_ZeitGabe_4Changed(int value);
	void slot_spinBoxspinBox_ZeitGabe_5Changed(int value);
	void slot_spinBoxGesammtkochdauerChanged(int value);
	void slot_TableWidget_cellChanged(int row, int column);
	void openRecentFile();
	void slot_pushButton_DatenUebertragen();
	void slot_Changed();
	void slot_pushButton_SudAbgefuellt();
	void slot_pushButton_EingabeHSWJungbier();
	void slot_pushButton_EingabeHSWSchnellgaerprobe();
	void slot_pushButton_EingabeHSWAnstellen();
	void slot_pushButton_EingabeHSWKochende();
	void slot_pushButton_AbfuelldatumHeute();
	void slot_pushButton_AnstelldatumHeute();
	void slot_pushButton_BraudatumHeute();
	void slot_print();
	void slot_pushButton_GeraeteNeu();
	void slot_pushButton_GeraeteDel();
	void slot_ComboBoxIndexChanged(int i);
	void slot_spinBoxValueChanged(int i);
	void save();
	void slot_pushButton_MalzDel();
	void slot_pushButton_MalzNeu();
	void slot_pushButton_HopfenDel();
	void slot_pushButton_HopfenNeu();
	void slot_pushButton_HefeDel();
	void slot_pushButton_HefeNeu();
	void slot_spinBoxValueChanged(double d);
	void slot_EwzAenderungRohstoffe();
	void on_pushButton_NeueRast_clicked();
	void on_pushButton_RastNachOben(int id);
	void on_pushButton_RastNachUnten(int id);
	void on_spinBox_WuerzemengeAnstellen_valueChanged(double arg1);
	void on_spinBox_SWKochende_valueChanged(double arg1);
	void on_spinBox_WuerzemengeKochende_valueChanged(double arg1);
	void on_spinBox_Speisemenge_valueChanged(double arg1);
	void on_spinBox_Menge_valueChanged(int arg1);
	void on_spinBox_SW_valueChanged(double arg1);
	void on_spinBox_WuerzemengeVorHopfenseihen_valueChanged(double arg1);
	void on_pushButton_BewertungNeu_clicked();
	void slot_BewertungWoche_clicked(int id);
	void slot_GraphicsView_AnzahlSterneChanged(int value);
	void on_dateEdit_Bewertungsdatum_dateChanged(const QDate &date);
	void on_textEdit_bewBemerkung_textChanged();
	void on_radioButton_farbe_0_clicked();
	void on_radioButton_farbe_1_clicked();
	void on_radioButton_farbe_2_clicked();
	void on_radioButton_farbe_3_clicked();
	void on_radioButton_farbe_4_clicked();
	void on_radioButton_farbe_5_clicked();
	void on_radioButton_farbe_6_clicked();
	void on_radioButton_farbe_7_clicked();
	void on_radioButton_farbe_8_clicked();
	void on_radioButton_farbe_9_clicked();
	void on_radioButton_farbe_10_clicked();
	void on_radioButton_schaum_0_clicked();
	void on_radioButton_schaum_1_clicked();
	void on_radioButton_schaum_2_clicked();
	void on_radioButton_schaum_3_clicked();
	void on_radioButton_schaum_4_clicked();
	void on_radioButton_schaum_5_clicked();
	void on_radioButton_schaum_6_clicked();
	void on_radioButton_schaum_7_clicked();
	void on_radioButton_schaum_8_clicked();
	void on_radioButton_schaum_9_clicked();
	void on_radioButton_schaum_10_clicked();
	void on_checkBox_geruch_0_clicked();
	void on_checkBox_geruch_1_clicked();
	void on_checkBox_geruch_2_clicked();
	void on_checkBox_geruch_3_clicked();
	void on_checkBox_geruch_4_clicked();
	void on_checkBox_geruch_5_clicked();
	void on_checkBox_geruch_6_clicked();
	void on_checkBox_geruch_7_clicked();
	void on_checkBox_geruch_8_clicked();
	void on_checkBox_geruch_9_clicked();
	void on_checkBox_geruch_10_clicked();
	void on_checkBox_geruch_11_clicked();
	void on_checkBox_geschmack_0_clicked();
	void on_checkBox_geschmack_1_clicked();
	void on_checkBox_geschmack_2_clicked();
	void on_checkBox_geschmack_3_clicked();
	void on_checkBox_geschmack_4_clicked();
	void on_checkBox_geschmack_5_clicked();
	void on_checkBox_geschmack_6_clicked();
	void on_checkBox_geschmack_7_clicked();
	void on_checkBox_geschmack_8_clicked();
	void on_checkBox_geschmack_9_clicked();
	void on_checkBox_geschmack_10_clicked();
	void on_checkBox_geschmack_11_clicked();
	void on_checkBox_geschmack_12_clicked();
	void on_radioButton_antrunk_0_clicked();
	void on_radioButton_antrunk_1_clicked();
	void on_radioButton_antrunk_2_clicked();
	void on_radioButton_antrunk_3_clicked();
	void on_radioButton_antrunk_4_clicked();
	void on_radioButton_antrunk_5_clicked();
	void on_radioButton_antrunk_6_clicked();
	void on_radioButton_antrunk_7_clicked();
	void on_radioButton_haupttrunk_0_clicked();
	void on_radioButton_haupttrunk_1_clicked();
	void on_radioButton_haupttrunk_2_clicked();
	void on_radioButton_haupttrunk_3_clicked();
	void on_radioButton_haupttrunk_4_clicked();
	void on_radioButton_nachtrunk_0_clicked();
	void on_radioButton_nachtrunk_1_clicked();
	void on_radioButton_nachtrunk_2_clicked();
	void on_radioButton_nachtrunk_3_clicked();
	void on_radioButton_nachtrunk_4_clicked();
	void on_radioButton_nachtrunk_5_clicked();
	void on_radioButton_nachtrunk_6_clicked();
	void on_radioButton_nachtrunk_7_clicked();
	void on_radioButton_nachtrunk_8_clicked();
	void on_radioButton_gesamteindruck_0_clicked();
	void on_radioButton_gesamteindruck_1_clicked();
	void on_radioButton_gesamteindruck_2_clicked();
	void on_radioButton_gesamteindruck_3_clicked();
	void on_radioButton_gesamteindruck_4_clicked();
	void on_radioButton_gesamteindruck_5_clicked();
	void on_radioButton_gesamteindruck_6_clicked();
	void on_radioButton_gesamteindruck_7_clicked();
	void on_textEdit_farbe_textChanged();
	void on_textEdit_schaum_textChanged();
	void on_textEdit_geruch_textChanged();
	void on_textEdit_geschmack_textChanged();
	void on_textEdit_antrunk_textChanged();
	void on_textEdit_haupttrunk_textChanged();
	void on_textEdit_nachtrunk_textChanged();
	void on_textEdit_gesamteindruck_textChanged();
	void on_pushButton_addStar_clicked();
	void on_pushButton_remStar_clicked();
};
#endif



















